$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    loadEmailTemplate(0, "");
    updateHeadingText();


    function loadEmailTemplate(round, emailtemp) {
        var request = $.ajax({
            url: '/' + subdir + '/email/get_template/f/' + framework_id,
            cache: false,
            data: 'id=1&selectedround=' + round + '&emailtemplatetype=' + emailtemp,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (CKEDITOR.instances['emaileditor']) {
                CKEDITOR.instances['emaileditor'].destroy(true);
            }
            $('#emaileditor').text(output.data[1]);
            CKEDITOR.replace('emaileditor', {
                filebrowserBrowseUrl: '/' + subdir + '/ckfinder/ckfinder.html',
                filebrowserUploadUrl: '/' + subdir + '/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files',
                extraAllowedContent: 'style;*[id,rel](*){*};'
            });
            CKEDITOR.instances['emaileditor'].on( 'pluginsLoaded', function() {
                CKEDITOR.instances['emaileditor'].filter.addElementCallback( function( el ) {
                    if ( el.name == 'img' ) {
                        return CKEDITOR.FILTER_SKIP_TREE;
                    }
                } );
            } );
            $('#emailsubject').val(output.data[0]);
        });


    }


    function updateHeadingText() {
        $headingtext = $('#template option:selected').text();
        if ($('#round option:selected').val() == 0) {
            $headingtext += " - DEFAULT TEMPLATE (will apply to all rounds if not otherwise specified)";
        }
        $('#heading').text($headingtext);
    }

    $('#round').change(function () {
        loadEmailTemplate($('#round option:selected').val(), $('#template option:selected').val());
        updateHeadingText();
    });
    $('#template').change(function () {
        loadEmailTemplate($('#round option:selected').val(), $('#template option:selected').val());
        updateHeadingText();
    });


    $('#submitchanges').click(function () {
        var emailtemp = $('#template option:selected').val();
        var round_id = $('#round option:selected').val();
        var emailtext = CKEDITOR.instances['emaileditor'].getData();
        var emailsubject = $('#emailsubject').val();
        $.when(confirm_request("Are you sure you want to save changes to this template?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/email/save_template/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            emailtext: emailtext,
                            emailsubject: emailsubject,
                            emailtemplatetype: emailtemp,
                            selectedround: round_id,
                            csrf_token: $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            show_message("Email template saved successfully.", 'success');
                            //$('html, body').animate({ scrollTop: 0 }, 'fast');
                        } else {
                            //hide_loading_message();
                            show_message('Save request failed ', 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        show_message('Save request failed ', 'danger');
                    });
                }
            }
        );
    });


    $('#surveyurl').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{surveyurl}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#surveyurlB').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{surveyurlB}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#firstname').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{firstname}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#lastname').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{lastname}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#attribute_2').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{attribute_2}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#attribute_3').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{attribute_3}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#attribute_6').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{attribute_6}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#attribute_7').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{attribute_7}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#attribute_8').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{attribute_8}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#survey_end_date').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{survey_end_date}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#daysleft').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{daysleft}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#participant_fname').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{participant_fname}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#participant_lname').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{participant_lname}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#nominate_date').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{nominate_date}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#minimum_respondents').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{minimum_respondents}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#participant_survey_date').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{participant_survey_date}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#respondent_survey_date').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{respondent_survey_date}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#respondent_survey_url').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{respondent_survey_url}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#participant_survey_url').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{participant_survey_url}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#portal_url').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{portal_url}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#temp_password').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{temp_password}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#login_token').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{login_token}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#new_password_url').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{new_password_url}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
    $('#username').click(function () {
        CKEDITOR.instances['emaileditor'].insertText('{username}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });

    $('#template').select2({
        minimumResultsForSearch: -1
    });

    $('.rater_text').click(function (){
        var text = $(this).data('rtype');
        CKEDITOR.instances['emaileditor'].insertText('{%'+text+'%}INSERT TEXT HERE{%/'+text+'%}');
        $("html, body").animate({scrollTop: $(document).height()}, "fast");
    });
});
