$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var thisdir = params[1] + '/' + params[2];
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    var table_attributes = $('#table_attributes').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/participant_attribute/get_attributes/f/' + framework_id,
            "data": function (d) {
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "name"},
            {"data": "participant_email"},
            {"data": "code"},
            {"data": "value"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        }
    });


    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            fiscal_year: {
                required: true,
                min: 2000,
                max: 2025
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_attributes = $('#form_attributes');
    form_attributes.validate();

    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    // Add participant button
    $(document).on('click', '#add_participant_attribute', function (e) {
        e.preventDefault();
        $('.lightbox_content h2').text('Add Attribute');
        $('#form_attributes button').html('Add Attribute');
        $('#form_attributes').attr('class', 'form add');
        $('#form_attributes .field_container label.error').hide();
        $('#form_attributes .field_container').removeClass('valid').removeClass('error');
        $('#form_attributes #participant_email').val('');
        $('#form_attributes #code').val('');
        $('#form_attributes #value').val('');


        hide_loading_message();
        show_lightbox();
    });

    // Add participant submit form
    $(document).on('submit', '#form_attributes.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_attributes.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_attributes').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/participant_attribute/add_attribute/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_attributes').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message("Attribute added successfully.", 'success');
                    }, true);
                } else {
                    hide_loading_message();
                    show_message('Add request failed', 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    // Edit company button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var participant_id = $(this).data('participant_id');
        var request = $.ajax({
            url: '/' + subdir + '/participant_attribute/get_attributes/f/' + framework_id,
            cache: false,
            data: {id:id},
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Edit Attribute');
                $('#form_attributes button').text('Edit Attribute');
                $('#form_attributes').attr('class', 'form edit');
                $('#form_attributes').attr('data-id', id);
                $('#form_attributes #participant_email').val(output.data[0].participant_email);
                $('#form_attributes #code').val(output.data[0].code);
                $('#form_attributes #value').val(output.data[0].value);// }


                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'error');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'error');
        });
    });

    // Edit company submit form
    $(document).on('submit', '#form_attributes.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_attributes.valid() == true) {
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_attributes').attr('data-id');
            var form_data = $('#form_attributes').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            $("input:checked").each(function () {
                myReportingGroups.push($(this).val());
            });
            var request = $.ajax({
                url: '/' + subdir + '/participant_attribute/edit_attribute/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'id':id}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_attributes').DataTable().ajax.reload(function () {
                    }, true);
                    hide_loading_message();
                    show_message("Attribute edited successfully.", 'success');
                } else {
                    hide_loading_message();
                    show_message('Edit request failed', 'error');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'error');
            });
        }
    });

    $(document).on('click', '.function_delete a', function (e) {
        e.preventDefault();
        var id = $(this).data('id');

        $.when(confirm_request("Are you sure you want to delete this attribute?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/participant_attribute/delete_participant_attribute/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            id: id,
                            csrf_token: $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_attributes').DataTable().ajax.reload(function () {
                            }, true);
                            show_message("Attribute deleted successfully.", 'success');
                        } else {
                            show_message('Delete request failed', 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed', 'danger');
                    });
                }
            }
        );
    });

    $(document).on('change', ':file', function () {
        var input = $(this),
            numFiles = input.get(0).files ? input.get(0).files.length : 1,
            label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
        input.trigger('fileselect', [numFiles, label]);
    });
    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            if (log) alert(log);
        }

    });
    $(document).on('click', '#importSubmit', function () {
        show_loading_message();
    });

    //hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });


});
