$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];

    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            password: {
                is_pw_strong: {
                    param: true
                }
            },
            confirm_password: {
                equalTo: "#password"
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });

    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 4000);

    var formnewpw = $('#formnewpw');
    formnewpw.validate();

    var checkmsg = "";
    $.validator.addMethod("pwcheck", function (value) {
        var output = check_password(true);
        var data = output.data;
        if (data != ""){
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Please meet all password criteria below'; // checkmsg;
    });

    $("#password").complexify({
            minimumChars: $('#pwl').val(),
            banMode: 'strict',
            strengthScaleFactor: $('#pwf').val(),
            bannedPasswords: custom_arr()
        },
        function (valid, complexity) {
            // Show percentage
            var outputstr = "";
            var cp = Math.round(complexity);
            if (cp < $('#pws').val()) {
                var strength = '<span style="color:darkorange"><strong>Strength: ' + cp + '</strong></span>';
            } else {
                var strength = '<span style="color:green"><strong>Strength: ' + cp + '</strong></span>';
            }
            var length = $("#password").val().length;
            if (length < $('#pwl').val()) {
                var lenstr = '<span style="color:darkorange"><strong>Length: ' + length + '</strong></span>';
            } else {
                var lenstr = '<span style="color:green"><strong>Length: ' + length + '</strong></span>';
            }
            outputstr = strength + '; ' + lenstr;
            $('#pw_strength').html(outputstr);
        }
    );
    function custom_arr(){
        if ($('#pwacw').val() == 1){
            var arr = [];
        } else {
            var arr = window.COMPLEXIFY_BANLIST;
        }
        return arr;
    }

    $.validator.addMethod("is_pw_strong", function (value) {
        var score;
        $("#password").complexify({
                minimumChars: $('#pwl').val(),
                banMode: 'strict',
                strengthScaleFactor: $('#pwf').val(),
                bannedPasswords: custom_arr()
            },
            function (valid, complexity) { //show de password level
                // Show percentage
                score = complexity;
            }
        );
        if (score < $('#pws').val() || $("#password").val().length < $('#pwl').val()) {
            return false;
        } else {
            return true;
        }
    }, function (params, element) {
        return 'Choose a strong password of at least '+$('#pwl').val()+' characters, containing no common words or identifying information (eg. your name), and a mix of letters, numbers and symbols'; // checkmsg;
    });


    function check_password(from_submit) {
        var pw = $('#password').val();
        var result;
        $.ajax({
            url: '/' + subdir + '/auth/pw_strength',
            type: "POST",
            async: false,
            data: {
                pw: pw,
                submit: from_submit,
                csrf_token: $('meta[name="csrf-token"]').attr('content')
            },
            dataType: "json",
            success: function (output) {
                result = output;
            }
        });
        return result;
    }

});