$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];

    /*
     * DATATABLE INITIALISATION
     */

    var table_respondents = $('#table_respondents').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_participant_respondents',
            "data": function (d) {
                //d.activeonly = $('#activeonly option:selected').val();
                d.showrejected = $('#showrejected option:selected').val();
                d.selectedparticipantid = $('#selectparticipant option:selected').val();
                d.type = 'manager';
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "partname"},
            {"data": "name"},
            {"data": "email"},
            {"data": "relationship"},
            {"data": "approved"},
            {"data": "framework_name"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "order": [],
        "aaSorting": [],
        "lengthMenu": [[20, 30, 50, 100, -1], [20, 30, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_respondents').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });

    setInterval(function () {
        $('#table_respondents').DataTable().ajax.reload(null, false);
    }, 120000);

    /*
     * ERROR HANDLING
     */


    $.fn.dataTable.ext.errMode = 'none';

    $('#table_respondents')
        .on('error.dt', function (e, settings, techNote, message) {
            // console.log( 'An error has been reported by DataTables: ', message );
            show_message("Table information could not refresh as there is a connection issue, you may have lost network connection or been logged out", 'danger');
            // window.location='index.php';
        })
        .DataTable();

    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }


    /*
     * EVENT HANDLERS
     */

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }


    // Approve all respondents
    $(document).on('click', '.function_approve_respondent a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var respondent_name = $(this).data('name');
        var id = $(this).data('id');

        var request = $.ajax({
            url: '/' + subdir + '/user_round/approve_respondent',
            data: {
                id: id,
                csrf_token: $('meta[name="csrf-token"]').attr('content')
            },
            cache: false,
            dataType: 'json',
            // contentType: 'application/json; charset=utf-8',
            type: 'POST'
        });

        request.done(function (output) {
            if (output.result == 'success') {
                // Reload datable
                show_message('Rater successfully approved', 'success');
                $('#table_respondents').DataTable().ajax.reload(function () {
                }, true);
            } else {
                show_message('Approval request failed: ' + output['message'], 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Invite request failed: ' + textStatus, 'danger');
        });
        //     }
        //   }
        // );
    });

    // Re-invite respondent (make sent=N)
    $(document).on('click', '.function_reject_respondent a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var respondent_name = $(this).data('name');
        var id = $(this).data('id');

        $.when(confirm_request("Are you sure you want to reject the nomination of '" + respondent_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/user_round/reject_respondent',
                        data: {
                            id: id,
                            csrf_token: $('meta[name="csrf-token"]').attr('content')
                        },
                        cache: false,
                        dataType: 'json',
                        type: 'POST'
                    });

                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message('Rater successfully rejected', 'success');
                            $('#table_respondents').DataTable().ajax.reload(function () {
                            }, true);
                        } else {
                            show_message('Error: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Reject request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });


    $(document).on('click', '#all_approved', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var participant_name = $('#selectparticipant option:selected').text()
        var id = $('#selectparticipant option:selected').val()

        $.when(confirm_request("Are you sure you want to approve all remaining raters for '" + participant_name + "'?")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/user_round/approve_all_respondents',
                        data: {
                            id:id,
                            csrf_token: $('meta[name="csrf-token"]').attr('content')
                        },
                        cache: false,
                        dataType: 'json',
                        type: 'POST'
                    });

                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            show_message('Raters successfully approved', 'success');
                            $('#table_respondents').DataTable().ajax.reload(function () {
                            }, true);
                        } else {
                            show_message('Approval request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Approval request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    $('#activeonly').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    $('#showrejected').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    $('#selectparticipant').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
        if ($('#selectparticipant option:selected').val() > 0) {
            $('#all_approved').prop('disabled', false);
        } else {
            $('#all_approved').prop('disabled', true);
        }
    });

    //hide search option for yes/no drop downs
    $('#showcancelled').select2({
        minimumResultsForSearch: -1
    });
    $('#activetype').select2({
        minimumResultsForSearch: -1
    });

});
